Imports ADODB

Public Class Time
    Inherits System.ComponentModel.Component

#Region " Component Designer generated code "

    Public Sub New(ByVal Container As System.ComponentModel.IContainer)
        MyClass.New()

        'Required for Windows.Forms Class Composition Designer support
        Container.Add(Me)
    End Sub
    Friend WithEvents OleDbSelectCommand1 As System.Data.OleDb.OleDbCommand
    Friend WithEvents OleDbInsertCommand1 As System.Data.OleDb.OleDbCommand
    Friend WithEvents OleDbUpdateCommand1 As System.Data.OleDb.OleDbCommand
    Friend WithEvents OleDbDeleteCommand1 As System.Data.OleDb.OleDbCommand
    Friend WithEvents OleDbDataAdapter1 As System.Data.OleDb.OleDbDataAdapter

    Public Sub New()
        MyBase.New()

        'This call is required by the Component Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call
        SetupDataSetMapping()
    End Sub

    'Required by the Component Designer
    Private components As System.ComponentModel.Container

    'NOTE: The following procedure is required by the Component Designer
    'It can be modified using the Component Designer.
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.OleDbSelectCommand1 = New System.Data.OleDb.OleDbCommand()
        Me.OleDbInsertCommand1 = New System.Data.OleDb.OleDbCommand()
        Me.OleDbUpdateCommand1 = New System.Data.OleDb.OleDbCommand()
        Me.OleDbDeleteCommand1 = New System.Data.OleDb.OleDbCommand()
        Me.OleDbDataAdapter1 = New System.Data.OleDb.OleDbDataAdapter()
        '
        'OleDbDataAdapter1
        '
        Me.OleDbDataAdapter1.DeleteCommand = Me.OleDbDeleteCommand1
        Me.OleDbDataAdapter1.InsertCommand = Me.OleDbInsertCommand1
        Me.OleDbDataAdapter1.SelectCommand = Me.OleDbSelectCommand1
        Me.OleDbDataAdapter1.UpdateCommand = Me.OleDbUpdateCommand1

    End Sub

#End Region

    Public Overloads Function Add(ByVal TimeInfo As TimeDS) As TimeDS
        Dim Recordset As _Recordset
        Dim Time As New TnEADO.Time()
        Dim NewID As Integer

        ' Create an empty Time Recordset
        Recordset = Time.Create()

        ' Populate the recordset with data from the dataset
        CopyToRecordset(Recordset, TimeInfo)

        ' Save the time
        NewID = Time.Add(Recordset)

        ' Load the saved time in order to catch any changes that may have taken 
        ' place in the COM component
        If NewID <> 0 Then
            TimeInfo = Me.Load(NewID)
        Else
            ' Throw an exception
        End If

        Return TimeInfo

    End Function

    Public Overloads Function Add(ByVal TimeEntries As TimeDS, ByVal SingleTransaction As Boolean) As TimeDS
        Dim TimeEntry As TnE.TimeDS
        Dim i As Integer

        'call the add method for each update
        For i = 0 To TimeEntries.Time.Rows.Count - 1
            TimeEntry = New TnE.TimeDS()
            Dim NewRow As TnE.TimeDS.TimeRow
            NewRow = TimeEntry.Time.NewTimeRow()

            NewRow.TimeType = Convert.ToInt32(TimeEntries.Time.Rows(i)("TimeType"))
            NewRow.Employee = Convert.ToString(TimeEntries.Time.Rows(i)("Employee"))
            NewRow.Calendar = Convert.ToDateTime(TimeEntries.Time.Rows(i)("Calendar"))
            NewRow.Start = Convert.ToString(TimeEntries.Time.Rows(i)("Start"))
            NewRow.Hours = Convert.ToDecimal(TimeEntries.Time.Rows(i)("Hours"))
            If NewRow.TimeType = TimeTypes.Client Then
                NewRow.Org = Convert.ToString(TimeEntries.Time.Rows(i)("Org"))
                NewRow.Project = Convert.ToString(TimeEntries.Time.Rows(i)("Project"))
                NewRow.Task = Convert.ToInt32(TimeEntries.Time.Rows(i)("Task"))
                NewRow.Description = ""
            Else
                NewRow.Org = ""
                NewRow.Project = ""
                NewRow.Task = 0
                NewRow.Description = Convert.ToString(TimeEntries.Time.Rows(i)("Description"))
            End If
            TimeEntry.Time.AddTimeRow(NewRow)

            'now call the base class implementation
            Add(TimeEntry)
        Next

    End Function

    Public Function BrowseByEmployeePeriod(ByVal Employee As String, ByVal Period As Date) As TimeDS
        Dim Recordset As _Recordset
        Dim TimeInfo As New TimeDS()
        Dim Time As New TnEADO.Time()

        Recordset = Time.BrowseByEmployeePeriod(Employee, Period)

        OleDbDataAdapter1.Fill(TimeInfo, Recordset, "time")

        Return TimeInfo
    End Function


    Public Function BrowseByEmployeeRange(ByVal Employee As String, ByVal StartDate As Date, ByVal StopDate As Date) As TimeDS
        Dim Recordset As _Recordset
        Dim TimeInfo As New TimeDS()
        Dim Time As New TnEADO.Time()

        Recordset = Time.BrowseByEmployeeRange(Employee, StartDate, StopDate)

        OleDbDataAdapter1.Fill(TimeInfo, Recordset, "time")

        Return TimeInfo

    End Function


    Public Function BrowseByProject(ByVal Org As String, ByVal Proj As String, ByVal StartDate As Date, ByVal StopDate As Date) As DataSet
        Dim Recordset As _Recordset
        Dim TimeInfo As New DataSet()
        Dim Time As New TnEADO.Time()

        Recordset = Time.BrowseByProject(Org, Proj, StartDate, StopDate)

        OleDbDataAdapter1.Fill(TimeInfo, Recordset, "time")

        Return TimeInfo

    End Function


    Public Function BrowseByProjectAll(ByVal Org As String, ByVal Proj As String, ByVal StartDate As Date, ByVal StopDate As Date) As DataSet
        Dim Recordset As _Recordset
        Dim TimeInfo As New DataSet()
        Dim Time As New TnEADO.Time()

        Recordset = Time.BrowseByProjectAll(Org, Proj, StartDate, StopDate)

        OleDbDataAdapter1.Fill(TimeInfo, Recordset, "time")

        Return TimeInfo
    End Function


    Public Function Create() As TimeDS
        Dim Recordset As _Recordset
        Dim TimeInfo As New TimeDS()
        Dim Time As New TnEADO.Time()

        Recordset = Time.Create()

        OleDbDataAdapter1.Fill(TimeInfo, Recordset, "time")

        Return TimeInfo
    End Function


    Public Function Load(ByVal TimeID As Integer) As TimeDS
        Dim Recordset As _Recordset
        Dim TimeInfo As New TimeDS()
        Dim Time As New TnEADO.Time()

        Recordset = Time.Load(TimeID)

        OleDbDataAdapter1.Fill(TimeInfo, Recordset, "time")

        Return TimeInfo

    End Function


    Public Function Save(ByVal TimeInfo As TimeDS) As TimeDS
        Dim Recordset As _Recordset
        Dim Time As New TnEADO.Time()
        Dim RowsAffected As Integer

        ' Create an empty Time Recordset
        Recordset = Time.Create()

        CopyToRecordset(Recordset, TimeInfo)

        ' Save the time
        RowsAffected = Time.Save(Recordset)

        ' Load the saved time in order to catch any changes that may have taken 
        ' place in the COM component
        If RowsAffected <> 0 Then
            TimeInfo = Me.Load(RowsAffected)
        Else
            ' Throw an exception
        End If

        Return TimeInfo

    End Function

    Public Function Delete(ByVal TimeInfo As TimeDS) As Integer
        Dim Recordset As _Recordset
        Dim Time As New TnEADO.Time()
        Dim RowsAffected As Integer

        ' Create an empty Time Recordset
        Recordset = Time.Create()

        ' Populate the recordset with data from the dataset
        CopyToRecordset(Recordset, TimeInfo)

        ' Delete the time
        RowsAffected = Time.Delete(Recordset)

        Return RowsAffected

    End Function

    Private Sub CopyToRecordset(ByRef Recordset As ADODB._Recordset, ByVal TimeInfo As TimeDS)
        ' Populate the recordset with data from the dataset
        With TimeInfo
            If .Time.Rows.Count > 0 Then
                Recordset.Fields.Item("time_id").Value = .Time(0).TimeID
                Recordset.Fields.Item("time_type").Value = .Time(0).TimeType
                Recordset.Fields.Item("employee").Value = .Time(0).Employee
                Recordset.Fields.Item("calendar").Value = .Time(0).Calendar
                Recordset.Fields.Item("description").Value = .Time(0).Description
                Recordset.Fields.Item("hours").Value = .Time(0).Hours
                Recordset.Fields.Item("org").Value = .Time(0).Org
                Recordset.Fields.Item("proj").Value = .Time(0).Project
                Recordset.Fields.Item("start").Value = .Time(0).Start
                Recordset.Fields.Item("task").Value = .Time(0).Task
            End If
        End With
    End Sub

    Private Sub SetupDataSetMapping()
        'Setup the mapping for the strongly typed DataSet
        Me.OleDbDataAdapter1.TableMappings.AddRange(New Data.Common.DataTableMapping() {New Data.Common.DataTableMapping("time", "Time", New Data.Common.DataColumnMapping() {New Data.Common.DataColumnMapping("time_id", "TimeId"), New Data.Common.DataColumnMapping("time_type", "TimeType"), New Data.Common.DataColumnMapping("employee", "Employee"), New Data.Common.DataColumnMapping("calendar", "Calendar"), New Data.Common.DataColumnMapping("start", "Start"), New Data.Common.DataColumnMapping("hours", "Hours"), New Data.Common.DataColumnMapping("org", "Org"), New Data.Common.DataColumnMapping("proj", "Project"), New Data.Common.DataColumnMapping("task", "Task"), New Data.Common.DataColumnMapping("description", "Description")})})
    End Sub

    Private Enum TimeTypes
        Client = 1
        Personal = 2
        NonClient = 3
    End Enum
End Class
